﻿using Spectral1.BUSINESS_LOGIC;
using Spectral1.PARSER;
using Spectral1_VBClassLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.IO.Compression;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.DATA_ACCESS
{
    public class DA_All
    {
        #region "=========== DECLARATIONS ================"
        public volatile CodeGen_DS_Spectral CGS = new CodeGen_DS_Spectral();
        public volatile CodeGen_DS_Spectral_System CGSS = new CodeGen_DS_Spectral_System();

        public DA_Spectral DASpectral;
        public DA_3DWireframe DA3D;
        public DA_System DASystem;
        public DA_USB_Comms DAUSBComms;
        string _current_file_name = "";
        private const string default_preset_root_folder_name = @"SpectralSoundModulePresets";
        #endregion

        #region "=========== PROPERTIES ================"
        public string current_file_name
        {
            get { return _current_file_name; }
        }
        #endregion

        #region "=========== METHODS ================"
        public DA_All()
        {
            DASpectral = new DA_Spectral();
            DA3D = new DATA_ACCESS.DA_3DWireframe();
            DASystem = new DA_System();
            DAUSBComms = new DA_USB_Comms(CGS);
            InitialiseSystemData();
            InitialiseSpectralData();
        }

        public void reset()
        {
            DASystem.flag_initialising_system = true;
            DASystem.flag_suppress_patch_events = true;
            DASystem.flag_saving_or_loading = true;
            DAUSBComms.suppress_comms = true;
            _current_file_name = "";
            Properties.Settings.Default.last_saved_filepath = "";
            Properties.Settings.Default.Save();
            DASpectral.data_changed.clear_changed_since_last_save();

            CGS.DeleteAllTableContents();
            InitialiseSpectralData();
            CGS.Table_system_settings.AddRow3(0, Properties.Settings.Default.default_performance_bank, Properties.Settings.Default.default_patch_bank, DA_Spectral.dataset_schema_version);

            DASystem.flag_saving_or_loading = false;
            DASystem.flag_initialising_system = false;
            DASystem.flag_suppress_patch_events = false;
            DAUSBComms.suppress_comms = false;

            DASpectral.data_changed.set_all(false);
        }

        public void InitialiseSpectralData()
        {
            CGS.Table_waveform_set.AddRow2("wwwwwwww", "--None--", Convert.ToInt32(DA_Spectral.timbre_modes.timbre_envelope), Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none), Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none));
            CGS.Table_body_resonance_filter.AddRow2("ffffffff", "--None--");
            CGS.AcceptChangesOnAllFileData();
        }

        private void InitialiseSystemData()
        {

            //Presets path
            if (Properties.Settings.Default.presets_path == "")
            {
                try
                {
                    string folder_path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), default_preset_root_folder_name) + @"\";
                    string helper_folder_path = Path.Combine(folder_path, "SDLHelpers");
                    string zip_file_path = folder_path + "SDLHelpers.zip";
                    if (!Directory.Exists(folder_path)) { 
                        Directory.CreateDirectory(folder_path);
                        File.Copy(@"Resources\SDLHelpers.zip", zip_file_path, true);
                        ZipFile.ExtractToDirectory(zip_file_path, folder_path);
                    }
                    
                    Properties.Settings.Default.presets_path = helper_folder_path;
                    Properties.Settings.Default.Save();
                }
                catch (Exception Ex)
                {
                    MessageBox.Show("Error trying to initialise SDL helper presets. Details :" + Ex.Message, "Error", MessageBoxButtons.OK);
                }
            }

            //Waveforms
            for (Int32 waveform_id = 0; waveform_id < DA_Spectral.max_waveforms; waveform_id++)
            {
                CGSS.Table_waveform.AddRow3(waveform_id, "Waveform " + waveform_id.ToString());
            }

            //MIDI channels
            for (Int32 midi_channel_id = 0; midi_channel_id < DA_Spectral.max_midi_channels; midi_channel_id++)
            {
                CGSS.Table_midi_channel.AddRow3(midi_channel_id, "CH" + (midi_channel_id + 1).ToString());
            }

            //MIDI notes
            Int32 octave_number;
            Int32 octave_note_number;
            string note_name;
            for (Int32 note_number = DA_Spectral.min_note_number; note_number <= DA_Spectral.max_note_number; note_number++)
            {
                octave_number = (note_number / DA_Spectral.notes_per_octave) - 1;
                octave_note_number = note_number % DA_Spectral.notes_per_octave;
                note_name = BL_MIDI.NoteNumberToName(octave_note_number) + octave_number.ToString();
                CGSS.Table_midi_note.AddRow3((Int32)note_number, note_name);
            }

            //Detuning modes
            CGSS.Table_detuning_mode.AddRow3(Convert.ToInt32(DA_Spectral.detune_modes.dm_cents), "Cents", 0);
            CGSS.Table_detuning_mode.AddRow3(Convert.ToInt32(DA_Spectral.detune_modes.dm_hz), "Hz", 0);

            //Intensity layer
            CGSS.Table_intensity_layer.AddRow3(0, "Low", 0);
            CGSS.Table_intensity_layer.AddRow3(1, "Medium", 0);
            CGSS.Table_intensity_layer.AddRow3(2, "High", 0);

            //Note sector
            CGSS.Table_note_sector.AddRow3(0, "C2 and below", 0);
            CGSS.Table_note_sector.AddRow3(1, "C#2 to E3", 0);
            CGSS.Table_note_sector.AddRow3(2, "F3 to G#4", 0);
            CGSS.Table_note_sector.AddRow3(3, "A4 to C6", 0);
            CGSS.Table_note_sector.AddRow3(4, "C#6 and above", 0);

            //ADSR section
            CGSS.Table_adsr_section.AddRow2("Attack", 0);
            CGSS.Table_adsr_section.AddRow2("Decay", 1);
            CGSS.Table_adsr_section.AddRow2("Sustain", 2);
            CGSS.Table_adsr_section.AddRow2("Release", 3);

            //MIDI CC
            CGSS.Table_cc_source.AddRow3(Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none), "--None--", 0);
            CGSS.Table_cc_source.AddRow3(Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_modulation), "Modulation", 1);
            CGSS.Table_cc_source.AddRow3(Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_breath_controller), "Breath Controller", 2);
            CGSS.Table_cc_source.AddRow3(Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_foot_controller), "Foot Controller", 3);
            CGSS.Table_cc_source.AddRow3(Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_expression), "Expression", 4);
            //Not visible:CGSS.Table_cc_source.AddRow3(Convert.ToInt32(used_midi_cc.ucc_sustain), "Sustain", 5);
            CGSS.Table_cc_source.AddRow3(Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_velocity), "Velocity", 6);

            //Envelope
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_amplitude), "Amplitude", 0);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise), "Noise gain", 1);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise_cutoff_level), "Noise cut-off freq", 2);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), "Timbre morph", 3);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), "Sample gain", 4);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), "Pitch shift", 5);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), "Tremolo depth", 6);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), "Vibrato depth", 7);
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), "Timbre lfo depth", 8);
          
            CGSS.Table_envelope.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_portamento), "Portamento", 9);
            CGSS.Table_envelope.AlternativeView.RowFilter = "envelope_id <> " + Convert.ToInt32(DA_Spectral.envelope.env_portamento).ToString();

            //Envelope types
            CGSS.Table_envelope_type.AddRow3(Convert.ToInt32(DA_Spectral.env_types.env_type_none), "None", 0);
            CGSS.Table_envelope_type.AddRow3(Convert.ToInt32(DA_Spectral.env_types.env_type_linear), "Linear", 1);
            CGSS.Table_envelope_type.AddRow3(Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), "Exp", 2);

            CGSS.Table_harmonic.AddRow3(0, "Fundamental", 0);
            for (int h = 1; h < 32; h++) { CGSS.Table_harmonic.AddRow3(h, "x" + (h + 1).ToString(), h); }

            //LFOs
            CGSS.Table_lfo.AddRow3(Convert.ToInt32(DA_Spectral.lfos.lfo_tremolo), "Tremolo", 0);
            CGSS.Table_lfo.AddRow3(Convert.ToInt32(DA_Spectral.lfos.lfo_vibrato), "Vibrato", 1);
            CGSS.Table_lfo.AddRow3(Convert.ToInt32(DA_Spectral.lfos.lfo_timbre), "Timbre lfo", 2);

            //Patch categories
            CGSS.Table_patch_category.AddRow3(Convert.ToInt32(DA_Spectral.effect.eff_none), "None", 0);
            CGSS.Table_patch_category.AddRow3(Convert.ToInt32(DA_Spectral.effect.eff_soft_clipping), "Soft clipping", 1);

            //Patch types
            CGSS.Table_patch_type.AddRow3(Convert.ToInt32(DA_Spectral.patch_types.pt_general_midi), "General Midi", 0);
            CGSS.Table_patch_type.AddRow3(Convert.ToInt32(DA_Spectral.patch_types.pt_user), "User", 1);

            //Sample
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_none), "None", 0);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_hammer1), "Key hammer 1", 1);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_hammer2), "Key hammer 2", 2);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_hammer3), "Key hammer 3", 3);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_hammer4), "Key hammer 4", 4);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_bowscrape1), "Bow scrape 1", 5);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_bowscrape2), "Bow scrape 2", 6);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_keyclick), "Key click", 7);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_keyup), "Key up", 8);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_very_long_not_filtered), "KS : Vlong decay", 9);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_long_not_filtered), "KS : Long decay", 10);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_normal_not_filtered), "KS : Std decay", 11);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_short_not_filtered), "KS : Short decay", 12);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_very_short_not_filtered), "KS : Vshort decay", 13);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_very_long_filtered), "KS : Vlong decay,filter", 14);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_long_filtered), "KS : Long decay,filter", 15);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_normal_filtered), "KS : Std decay,filter", 16);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_short_filtered), "KS : Short decay,filter", 17);
            CGSS.Table_sample.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_KS_very_short_filtered), "KS : Vshort decay,filter", 18);

            //Sample playback modes
            CGSS.Table_sample_playback_mode.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_sample_playback_modes.sample_playback_mode_one_shot), "One-shot", 1);
            CGSS.Table_sample_playback_mode.AddRow3(Convert.ToInt32(DA_Spectral.inharmonic_sample_playback_modes.sample_playback_mode_looped), "Looped", 2);

            //Timbre modes
            CGSS.Table_timbre_mode.AddRow3(Convert.ToInt32(DA_Spectral.timbre_modes.timbre_mode_2d), "2D morph", 0);
            CGSS.Table_timbre_mode.AddRow3(Convert.ToInt32(DA_Spectral.timbre_modes.timbre_envelope), "Timbre Envelope", 0);

            //Phase settings
            CGSS.Table_phase_setting.AddRow3(Convert.ToInt32(DA_Spectral.phase_settings.phase_all_in_phase), "All in phase");
            CGSS.Table_phase_setting.AddRow3(Convert.ToInt32(DA_Spectral.phase_settings.phase_inv_even), "Invert even");
            CGSS.Table_phase_setting.AddRow3(Convert.ToInt32(DA_Spectral.phase_settings.phase_inv_odd), "Invert odd");
            CGSS.Table_phase_setting.AddRow3(Convert.ToInt32(DA_Spectral.phase_settings.phase_inv_3711), "Invert 3,7,11...");

            //Filter types
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.lowpass), "Low-pass", 0);
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.highpass), "High-pass", 1);
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.bandpass), "Band-pass", 2);
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.lowshelf), "Low-shelf", 3);
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.highshelf), "High-shelf", 4);
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.notch), "Notch", 5);
            CGSS.Table_filter_type.AddRow3(Convert.ToInt32(DA_Spectral.filter_types.peak), "Peak", 6);

            //Wave types
            CGSS.Table_lfo_wave_type.AddRow3(Convert.ToInt32(DA_Spectral.lfo_wave_types.sine), "Sine");
            CGSS.Table_lfo_wave_type.AddRow3(Convert.ToInt32(DA_Spectral.lfo_wave_types.square), "Square");
            CGSS.Table_lfo_wave_type.AddRow3(Convert.ToInt32(DA_Spectral.lfo_wave_types.triangle), "Triangle");
            CGSS.Table_lfo_wave_type.AddRow3(Convert.ToInt32(DA_Spectral.lfo_wave_types.saw), "Saw");

            //Wave editing actions - removed

            //Presets - Amplitude
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_amplitude), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_amplitude_HammeredString), "Hammered string", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 80, 10, 0, 0, 0, 0, 0, (float)12.5, (float)12.5, (float)0.39, (float)12.5, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_amplitude), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_amplitude_SlowAttack), "Slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 80, 10, 0, 0, 0, 0, 0, (float)6, (float)6, (float)0.39, (float)12.5, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_amplitude), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_amplitude_VerySlowAttack), "Very slow attack", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 80, 10, 0, 0, 0, 0, 0, (float)3, (float)3, (float)0.39, (float)12.5, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_amplitude), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_amplitude_Organlike), "Organ", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 100, 100, 0, 0, 0, 0, 0, (float)12, (float)12, (float)12, (float)12.5, 0);

            //Presets - Sample
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_AttackOnLevel100), "Attack level 100%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 0, 0, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_AttackOnLevel75), "Attack level 75%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 75, 0, 0, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)0, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_AttackOnLevel50), "Attack level 50%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 50, 0, 0, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)0, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_AttackOnLevel25), "Attack level 25%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 25, 0, 0, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)0, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_SustainOnLevel25), "Sustain level 25%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 25, 0, 0, 0, 0, 0, (float)0, (float)0, (float)25, (float)0, 4);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_ReleaseOnLevel25), "Release level 25%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 25, 0, 0, 0, 0, (float)0, (float)0, (float)0, (float)25, 5);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_AttackOnLevel10), "Attack level 10%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 10, 0, 0, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)0, 6);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_SustainOnLevel10), "Sustain level 10%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 10, 0, 0, 0, 0, 0, (float)0, (float)0, (float)25, (float)0, 7);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_ReleaseOnLevel10), "Release level 10%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 10, 0, 0, 0, 0, (float)0, (float)0, (float)0, (float)25, 8);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_AttackOnLevel5), "Attack level 5%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 5, 0, 0, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)0, 9);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_SustainOnLevel5), "Sustain level 5%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 5, 0, 0, 0, 0, 0, (float)0, (float)0, (float)25, (float)0, 10);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_ReleaseOnLevel5), "Release level 5%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 5, 0, 0, 0, 0, (float)0, (float)0, (float)0, (float)25, 11);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_KS_100), "Karplus Strong 100%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 100, 100, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)12, 12);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_KS_75), "Karplus Strong 75%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 75, 75, 75, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)12, 13);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_KS_50), "Karplus Strong 50%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 50, 50, 50, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)12, 14);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_KS_25), "Karplus Strong 25%", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 25, 25, 25, 0, 0, 0, 0, 0, (float)25, (float)25, (float)0, (float)12, 15);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_sample), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_sample_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, (float)0, (float)0, (float)0, (float)0, 16);

            //Presets - Tremolo
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_DeepAndSlow), "Deep and slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 70, 70, 70, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_ShallowAndSlow), "Shallow and slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 15, 15, 15, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_DeepAndFast), "Deep and fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 70, 70, 70, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_ShallowAndFast), "Shallow and fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 15, 15, 15, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_BulkSetExpDSR), "Bulk set Exp mult% DSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_BulkSetLinearDSR), "Bulk set Linear Delta DSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_tremolo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_tremolo_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6);

            //Presets - Vibrato
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_DeepAndSlow), "Deep and slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 70, 70, 70, 70, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_ShallowAndSlow), "Shallow and slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 15, 15, 15, 15, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_DeepAndFast), "Deep and fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 70, 70, 70, 70, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_ShallowAndFast), "Shallow and fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 15, 15, 15, 15, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_BulkSetExpADSR), "Bulk set Exp mult% ADSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_BulkSetLinearADSR), "Bulk set Linear Delta ADSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_vibrato), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_vibrato_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6);

            //Presets - Timbre
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_FastSweepUp), "Fast sweep up", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 100, 100, 100, 100, 5000, 5000, 5000, 5000, 1, 1, 1, 1, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_SlowSweepUp), "Slow sweep up", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 100, 100, 100, 100, 1000, 1000, 1000, 1000, 1, 1, 1, 1, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_ExpVeryFastSweepUp), "Exponential Very Fast sweep up", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 100, 100, 100, 0, 0, 0, 0, (float)10, (float)10, (float)10, (float)10, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_ExpFastSweepUp), "Exponential Fast sweep up", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 100, 100, 100, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_ExpSlowSweepUp), "Exponential Slow sweep up", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 100, 100, 100, 100, 0, 0, 0, 0, (float)1, (float)1, (float)1, (float)1, 4);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_FastSweepDown), "Fast sweep down", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 0, 0, 0, 0, 5000, 5000, 5000, 5000, 1, 1, 1, 1, 5);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_SlowSweepDown), "Slow sweep down", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 0, 0, 0, 0, 1000, 1000, 1000, 1000, 1, 1, 1, 1, 6);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_ExpVeryFastSweepDown), "Exponential Very Fast sweep down", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, (float)10, (float)10, (float)10, (float)10, 7);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_ExpFastSweepDown), "Exponential Fast sweep down", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 8);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_ExpSlowSweepDown), "Exponential Slow sweep down", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, (float)1, (float)1, (float)1, (float)1, 9);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_BulkSetExpADSR), "Bulk set Exp mult% ADSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_BulkSetLinearADSR), "Bulk set Linear Delta ADSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12);

            //Presets - Timbre LFO
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_DeepAndSlow), "Deep and slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 70, 70, 70, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_ShallowAndSlow), "Shallow and slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 15, 15, 15, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_DeepAndFast), "Deep and fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 70, 70, 70, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_ShallowAndFast), "Shallow and fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 15, 15, 15, 0, 0, 0, 0, (float)3.125, (float)3.125, (float)3.125, (float)3.125, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_BulkSetExpDSR), "Bulk set Exp mult% DSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_BulkSetLinearDSR), "Bulk set Linear Delta DSR", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_timbre_lfo), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_timbre_lfo_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6);

            //Presets - Noise
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_QuickSoftPuff), "Quick soft puff", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 50, 3, 0, 0, 85, 50, 5, 5, 1, 1, 1, 1, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_SlowSoftPuff), "Slow soft puff", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 50, 3, 0, 0, 85, 50, 5, 5, 1, 1, 1, 1, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_QuickHardPuff), "Quick hard puff", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 20, 2, (float)0.5, 0, 0, 0, 0, 0, 5, 2, 2, 1, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_SlowHardPuff), "Slow hard puff", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 20, 2, (float)0.5, 0, 0, 0, 0, 0, 3, 1, 1, 1, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4);

            //Presets - Noise cutoff
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise_cutoff_level), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_co_apply_lpf_exp_fast), "Apply LPF Exp Fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 10, 10, 20, 0, 0, 0, 0, 0, 2, 2, 2, 3, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise_cutoff_level), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_co_apply_lpf_exp_slow), "Apply LPF Exp Slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 10, 10, 20, 0, 0, 0, 0, 0, 1, 1, 1, 2, 1);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise_cutoff_level), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_co_BulkSetExpADSR), "Bulk set Exp mult% ADSR", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise_cutoff_level), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_co_BulkSetLinearADSR), "Bulk set Linear Delta ADSR", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_noise_cutoff_level), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_noise_co_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4);

            //Preset - Pitch
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_slow_linear_drop), "Apply Pitch Drop Linear Slow", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 0, 0, 0, 0, 400, 400, 400, 0, 0, 0, 0, 0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_fast_linear_drop), "Apply Pitch Drop Linear Fast", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 0, 0, 0, 0, 800, 800, 800, 0, 0, 0, 0, 0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_slow_linear_rise), "Apply Pitch Rise Linear Slow", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 50, 50, 50, 50, 400, 400, 400, 0, 0, 0, 0, 0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_fast_linear_rise), "Apply Pitch Rise Linear Fast", Convert.ToInt32(DA_Spectral.env_types.env_type_linear), 50, 50, 50, 50, 800, 800, 800, 0, 0, 0, 0, 0, 0);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_slow_exp_drop), "Apply Pitch Drop Exp Slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_fast_exp_drop), "Apply Pitch Drop Exp Fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_slow_exp_rise), "Apply Pitch Rise Exp Slow", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 50, 50, 50, 50, 0, 0, 0, 0, 2, 2, 2, 0, 0);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_fast_exp_rise), "Apply Pitch Rise Exp Fast", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 50, 50, 50, 50, 0, 0, 0, 0, 4, 4, 4, 0, 0);

            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_BulkSetExpADSR), "Bulk set Exp mult% ADSR", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_BulkSetLinearADSR), "Bulk set Linear Delta ADSR", Convert.ToInt32(DA_Spectral.env_types.env_type_exponential), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3);
            CGSS.Table_adsr_preset.AddRow3(Convert.ToInt32(DA_Spectral.envelope.env_pitch), Convert.ToInt32(DA_Spectral.adsr_presets.env_pres_pitch_Clear), "Clear", Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4);

            //MIDI Settings
            CGS.Table_system_settings.AddRow3(0, Properties.Settings.Default.default_performance_bank, Properties.Settings.Default.default_patch_bank, DA_Spectral.dataset_schema_version);
        }

        #endregion

        #region "================= METHODS - SAVE/LOAD ================"

        public string Save()
        {
            string error_text = "";
            DASystem.flag_suppress_patch_events = true;
            DASystem.flag_saving_or_loading = true;

            try
            {
                if (Properties.Settings.Default.last_saved_filepath != null && Properties.Settings.Default.last_saved_filepath != "")
                {
                    DAUSBComms.suppress_comms = true;
                    SaveAsBinaryFile(Properties.Settings.Default.last_saved_filepath);
                    DAUSBComms.suppress_comms = false;
                }
                else
                {
                    error_text = SaveAs();
                }
            }
            catch
            {
                error_text = SaveAs();
            }
            finally
            {
                DASystem.flag_suppress_patch_events = false;
                DASystem.flag_saving_or_loading = false;
            }

            return error_text;
        }

        public string SaveAs()
        {
            string error_text = "";

            using (System.Windows.Forms.SaveFileDialog saveFileDialog1 = new System.Windows.Forms.SaveFileDialog())
            {
                try
                {
                    if (Properties.Settings.Default.last_saved_filepath != null && Properties.Settings.Default.last_saved_filepath != "")
                    {
                        saveFileDialog1.InitialDirectory = Path.GetFullPath(Properties.Settings.Default.last_saved_filepath);
                        saveFileDialog1.FileName = Path.GetFileName(Properties.Settings.Default.last_saved_filepath);
                    }

                    saveFileDialog1.RestoreDirectory = true;
                    saveFileDialog1.Title = "Save";
                    saveFileDialog1.DefaultExt = "xml";
                    saveFileDialog1.Filter = "Spectral Sound Module files (*.spectral)|*.spectral";//"txt files (*.xml)|*.xml";

                    if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        DAUSBComms.suppress_comms = true;
                        SaveAsBinaryFile(saveFileDialog1.FileName);

                        Properties.Settings.Default.last_saved_filepath = saveFileDialog1.FileName;
                        Properties.Settings.Default.Save();
                        _current_file_name = Path.GetFileNameWithoutExtension(saveFileDialog1.FileName);
                        DASystem.AddFileToRecentlyUsed(saveFileDialog1.FileName);
                        DASystem.SaveRecentlyUsedFiles();
                        DAUSBComms.suppress_comms = false;
                    }
                }
                catch (Exception ex)
                {
                    error_text = "Error saving file : " + ex.Message;
                    _current_file_name = "";
                }
            }

            DASystem.flag_suppress_patch_events = false;
            DASystem.flag_saving_or_loading = false;

            return error_text;
        }

        private void SaveAsBinaryFile(string filename)
        {
            using (FileStream stream = new FileStream(filename, FileMode.Create))
            {
                CGS.DSSPECTRAL.RemotingFormat = SerializationFormat.Binary;
                BinaryFormatter format = new BinaryFormatter();
                format.Serialize(stream, CGS.DSSPECTRAL);
                stream.Flush();
                CGS.AcceptChangesOnAllFileData();//Added 271221
                DASpectral.data_changed.clear_changed_since_last_save();
            }
        }

        public string OpenFile(string filename)
        {
            string error_text = "";
            try
            {
                DASystem.flag_saving_or_loading = true;
                DASystem.flag_suppress_patch_events = true;
                DAUSBComms.suppress_comms = true;

                using (FileStream stream = new FileStream(filename, FileMode.Open))
                {
                    BinaryFormatter format = new BinaryFormatter();
                    Spectral1_VBClassLibrary.DataSet_Spectral new_ds = (Spectral1_VBClassLibrary.DataSet_Spectral)format.Deserialize(stream);

                    /*NOTE: Deserialization creates a new object. Can't just assign CGS.DSSPECTRAL to new object because 
                     * all the table and binding source objects don't get updated.
                     * Therefore only simple way is to merge data.
                     */
                    for (Int32 i = 0; i < CGS.DSSPECTRAL.Tables.Count; i++)
                    {
                        CGS.DSSPECTRAL.Tables[i].Clear();
                        CGS.DSSPECTRAL.Tables[i].Merge(new_ds.Tables[i]);
                    }
                    CGS.DSSPECTRAL.AcceptChanges();
                }


                Properties.Settings.Default.last_opened_filepath = filename;
                Properties.Settings.Default.Save();

                DASystem.AddFileToRecentlyUsed(filename);
                DASystem.SaveRecentlyUsedFiles();

                DASpectral.data_changed.set_all(true);
                _current_file_name = Path.GetFileNameWithoutExtension(filename);
                DASpectral.data_changed.clear_changed_since_last_save();
            }
            catch (Exception ex)
            {
                error_text = "Error trying to open file.  Detail : " + ex.Message;
                _current_file_name = "";
            }
            finally 
            {
                DASystem.flag_suppress_patch_events = false;
                DAUSBComms.suppress_comms = false;
                DASystem.flag_saving_or_loading = false;
            }
            return error_text;
        }
        #endregion

        #region "================== METHODS - COMMS ================="
        public void sync_module(double level_scaling, double filter_scaling_factor)
        {
            DAUSBComms.send_to_module_stop_play_mode();

            int p = CGS.Table_patch.CurrentRow.patch_id;
            int ws = CGS.Table_waveform_set.CurrentRow.waveform_set_id;
            int f = CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id;

            //Patch misc
            if (DASpectral.data_changed.patch.get_misc() ==true)
            {
                DAUSBComms.send_to_module_patch_misc(p);
                DASpectral.data_changed.patch.set_misc(false);
            }

            //Patch ADSR Section
            for (int s = 0; s < DA_Spectral.max_adsr_sections; s++)
            {
                if (DASpectral.data_changed.patch.get_adsr_section(s) == true)
                {
                    DAUSBComms.send_to_module_adsr_section(p, s);
                    DASpectral.data_changed.patch.set_adsr_section(s,false);
                }
            }

            //Patch ADSR Section Envelope Config
            for (int s = 0; s < DA_Spectral.max_adsr_sections; s++)
            {
                for (int e = 0; e < DA_Spectral.max_envelopes; e++)
                {
                    if (DASpectral.data_changed.patch.get_adsr_section_envelope_config(s, e) == true)
                    {
                        DAUSBComms.send_to_module_adsr_section_envelope_config(p, s, e);
                        DASpectral.data_changed.patch.set_adsr_section_envelope_config(s, e,false);
                    }
                }

            }

            //Patch envelope control config
            for (int e = 0; e < DA_Spectral.max_envelopes; e++)
            {
                if (DASpectral.data_changed.patch.get_envelope_control_config(e) == true)
                {
                    DAUSBComms.send_to_module_envelope_control_config(p, e);
                    DASpectral.data_changed.patch.set_envelope_control_config(e,false);
                }
            }

            //Patch lfo envelope config
            for (int l = 0; l < DA_Spectral.max_lfos; l++)
            {
                if (DASpectral.data_changed.patch.get_lfo_envelope_config(l) == true)
                {
                    DAUSBComms.send_to_module_lfo_envelope_config(p, l);
                    DASpectral.data_changed.patch.set_lfo_envelope_config(l,false);
                }
            }

            //WaveSet
            if (DASpectral.data_changed.waveset.get_waveset_row() == true)
            {
                DAUSBComms.send_to_module_waveform_set(ws);
                DASpectral.data_changed.waveset.set_waveset_row(false);
            }
            for (int n = 0; n < DA_Spectral.max_note_sectors; n++)
            {
                for (int i = 0; i < DA_Spectral.max_intensity_layers; i++)
                {
                    for (int w = 0; w < DA_Spectral.max_waveforms; w++)
                    {
                        if (DASpectral.data_changed.waveset.get_waveform_harmonics_changed(n, i, w) == true)
                        {
                            DAUSBComms.send_to_module_waveform_harmonics(ws, n, i, w, p, level_scaling);
                            DASpectral.data_changed.waveset.set_waveform_harmonics_changed(n, i, w, false);
                        }
                    }
                }
            }

            //Filter
            DAUSBComms.RecalcFilterSlopes(f, filter_scaling_factor);
            for (int b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                if (DASpectral.data_changed.filter.get_body_resonance_filter_band(b) == true)
                {
                    DAUSBComms.send_to_module_body_resonance_filter_band(f, b, filter_scaling_factor);
                    DASpectral.data_changed.filter.set_body_resonance_filter_band(b,false);
                }
            }

            DAUSBComms.send_to_module_start_play_mode();
        }
        #endregion

        #region "============== METHODS - IMPORT/EXPORT ==============="
        public string ExportToFile(DataGridViewRowCollection dgv_pick_rows, string FilePathToSaveTo)
        {
            CodeGen_DS_Spectral eCGS = new CodeGen_DS_Spectral();
            string error_text = "";

            DASystem.flag_suppress_patch_events = true;
            DASystem.flag_saving_or_loading = true;
            DASystem.flag_importing_exporting = true;

            try
            {
                DAUSBComms.suppress_comms = true;

                //Put the data from the current dataset into the export dataset
                for (Int32 i = 0; i < eCGS.DSSPECTRAL.Tables.Count; i++)
                {
                    eCGS.DSSPECTRAL.Tables[i].Clear();
                    eCGS.DSSPECTRAL.Tables[i].Merge(CGS.DSSPECTRAL.Tables[i]);
                }
                eCGS.AcceptChangesOnAllFileData();

                //Delete all performances and patchSets because these aren't required
                eCGS.Table_patch_set.DT.Rows.Clear();
                eCGS.Table_patch_set_patches.DT.Rows.Clear();
                eCGS.Table_performance.DT.Rows.Clear();
                eCGS.Table_performance_channel.DT.Rows.Clear();
                eCGS.Table_performance_processor.DT.Rows.Clear();

                //Delete all the patches and associated tables, that aren't selected
                List<int> used_waveform_set_ids = new List<int>();
                List<int> used_filter_ids = new List<int>();
                Int32 waveform_set_id;
                Int32 body_resonance_filter_id;

                for (Int32 r = 0; r < dgv_pick_rows.Count; r++)
                {

                    if (dgv_pick_rows[r].Selected == false)
                    {
                        Int32 patch_id = Convert.ToInt32(dgv_pick_rows[r].Cells["patch_id"].Value);
                        eCGS.Table_patch.DeleteRow(patch_id); //Also deletes related rows in other tables
                    }
                    else
                    {
                        waveform_set_id = Convert.ToInt32(dgv_pick_rows[r].Cells["waveform_set_id"].Value);
                        body_resonance_filter_id = Convert.ToInt32(dgv_pick_rows[r].Cells["body_resonance_filter_id"].Value);
                        if (!used_waveform_set_ids.Contains(waveform_set_id)) { used_waveform_set_ids.Add(waveform_set_id); }
                        if (!used_filter_ids.Contains(body_resonance_filter_id)) { used_filter_ids.Add(body_resonance_filter_id); }
                    }
                }
                eCGS.AcceptChangesOnAllFileData();

                DataRow dr;
                //Delete any Waveform sets that aren't used
                for (int wsr = 0; wsr < eCGS.Table_waveform_set.RowCount(); wsr++)
                {
                    dr = eCGS.Table_waveform_set.DT.Rows[wsr];
                    waveform_set_id = dr.Field<Int32>("waveform_set_id");
                    if (!used_waveform_set_ids.Contains(waveform_set_id) && (waveform_set_id != 0))
                    {
                        dr.Delete();
                    }
                }

                for (int wf = 0; wf < eCGS.Table_waveform.RowCount(); wf++)
                {
                    dr = eCGS.Table_waveform.DT.Rows[wf];
                    waveform_set_id = dr.Field<Int32>("waveform_set_id");
                    if (!used_waveform_set_ids.Contains(waveform_set_id) && (waveform_set_id != 0))
                    {
                        dr.Delete();
                    }
                }

                for (int wfh = 0; wfh < eCGS.Table_waveform_harmonic.RowCount(); wfh++)
                {
                    dr = eCGS.Table_waveform_harmonic.DT.Rows[wfh];
                    waveform_set_id = dr.Field<Int32>("waveform_set_id");
                    if (!used_waveform_set_ids.Contains(waveform_set_id) && (waveform_set_id != 0))
                    { dr.Delete(); }
                }

                //Delete any filters that aren't used
                for (int f = 0; f < eCGS.Table_body_resonance_filter.RowCount(); f++)
                {
                    dr = eCGS.Table_body_resonance_filter.DT.Rows[f];
                    body_resonance_filter_id = dr.Field<Int32>("body_resonance_filter_id");
                    if (!used_filter_ids.Contains(body_resonance_filter_id) && (body_resonance_filter_id != 0))
                    { dr.Delete(); }
                }

                for (int fb = 0; fb < eCGS.Table_body_resonance_filter_band.RowCount(); fb++)
                {
                    dr = eCGS.Table_body_resonance_filter_band.DT.Rows[fb];
                    body_resonance_filter_id = dr.Field<Int32>("body_resonance_filter_id");
                    if (!used_filter_ids.Contains(body_resonance_filter_id) && (body_resonance_filter_id != 0))
                    { dr.Delete(); }
                }

                //Now save the file
                eCGS.AcceptChangesOnAllFileData();
                using (FileStream stream = new FileStream(FilePathToSaveTo, FileMode.Create))
                {
                    eCGS.DSSPECTRAL.RemotingFormat = SerializationFormat.Binary;
                    BinaryFormatter format = new BinaryFormatter();
                    format.Serialize(stream, eCGS.DSSPECTRAL);
                    stream.Flush();
                }
            }
            catch (Exception ex)
            {
                error_text = "Error exporting : " + ex.Message;
            }
            finally
            {
                DASystem.flag_suppress_patch_events = false;
                DASystem.flag_saving_or_loading = false;
                DASystem.flag_importing_exporting = false;
                eCGS.DisposeOfAllComponents();
            }

            return error_text;
        }

        private bool PatchGUIDExists(string patch_guid)
        {
            foreach (DataRow pr in CGS.Table_patch.DT.Rows)
            {
                if (pr.Field<string>("patch_guid8") == patch_guid) { return true; }
            }
            return false;
        }

        private bool WaveformSetGUIDExists(string waveform_set_guid8)
        {
            foreach (DataRow pr in CGS.Table_waveform_set.DT.Rows)
            {
                if (pr.Field<string>("waveform_set_guid8") == waveform_set_guid8) { return true; }
            }
            return false;
        }


        private Int32 GetExistingWaveformSetIDFromGUID(string waveform_set_guid8)
        {
            foreach (DataRow pr in CGS.Table_waveform_set.DT.Rows)
            {
                if (pr.Field<string>("waveform_set_guid8") == waveform_set_guid8) { return pr.Field<Int32>("waveform_set_id"); }
            }
            return -1;
        }

        private bool FilterGUIDExists(string body_resonance_filter_guid8)
        {
            foreach (DataRow pr in CGS.Table_body_resonance_filter.DT.Rows)
            {
                if (pr.Field<string>("body_resonance_filter_guid8") == body_resonance_filter_guid8) { return true; }
            }
            return false;
        }

        private Int32 GetFilterIDFromGUID(string body_resonance_filter_guid8)
        {
            foreach (DataRow pr in CGS.Table_body_resonance_filter.DT.Rows)
            {
                if (pr.Field<string>("body_resonance_filter_guid8") == body_resonance_filter_guid8) { return pr.Field<Int32>("body_resonance_filter_id"); }
            }
            return -1;
        }


        public string ImportFromFile(DataGridViewSelectedRowCollection dgv_pick_rows,ref string import_summary, ref CodeGen_DS_Spectral iCGS)
        {
            string error_text = "";

            Int32 patches_imported = 0;
            DASystem.flag_initialising_system = true;
            DASystem.flag_saving_or_loading = true;
            DASystem.flag_suppress_patch_events = true;
            DASystem.flag_importing_exporting = true;

            //Import patch related tables
            for (Int32 r = 0; r < dgv_pick_rows.Count; r++)
            {
                //Check to see if we already have a patch with the same GUID
                Int32 import_patch_id = Convert.ToInt32(dgv_pick_rows[r].Cells["patch_id"].Value);
                string import_patch_guid = (string)(dgv_pick_rows[r].Cells["patch_guid8"].Value);
                string import_patch_name = (string)(dgv_pick_rows[r].Cells["patch_name"].Value);

                if (PatchGUIDExists(import_patch_guid) == true)
                {
                    import_summary += "Skipped import of patch '" + import_patch_name + "' because it already exists" + "\r\n";
                }
                else
                {
                    patchRow import_pr = iCGS.Table_patch.GetRow(import_patch_id);
                    Int32 new_patch_id = CGS.Table_patch.AddRow2(import_pr.patch_guid8, import_pr.patch_name, import_pr.patch_type_id, import_pr.patch_category_id, import_pr.waveform_set_id, import_pr.body_resonance_filter_id, import_pr.sustain_enabled, import_pr.pitch_bend_enabled, import_pr.portamento_enabled, import_pr.portamento_rate, import_pr.degree_of_regular_detuning, import_pr.degree_of_random_detuning, import_pr.degree_of_random_phase, import_pr.active_layers, import_pr.detuning_mode_id, import_pr.layer0_st_inc_q11_5_detune, import_pr.layer1_st_inc_q11_5_detune, import_pr.layer2_st_inc_q11_5_detune, import_pr.key_scale_split_note_id);

                    for (Int32 i = 0; i < DA_Spectral.max_lfos; i++)
                    {
                        CGS.Table_lfo_envelope_config.AddRow3(new_patch_id, i, 0, 0, 0, Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none), Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none));
                        lfo_envelope_configRow import_lfoecr = iCGS.Table_lfo_envelope_config.GetRow(import_patch_id, i);
                        lfo_envelope_configRow new_lfoecr = CGS.Table_lfo_envelope_config.GetRow(new_patch_id, i);
                        new_lfoecr.default_wt_inc_q11_5 = import_lfoecr.default_wt_inc_q11_5;
                        new_lfoecr.depth_cc_source = import_lfoecr.depth_cc_source;
                        new_lfoecr.enabled = import_lfoecr.enabled;
                        new_lfoecr.freq_cc_source = import_lfoecr.freq_cc_source;
                        new_lfoecr.lfo_wave_type_id = import_lfoecr.lfo_wave_type_id;
                    }

                    for (Int32 a = 0; a < DA_Spectral.max_adsr_sections; a++)
                    {
                        CGS.Table_adsr_section.AddRow3(new_patch_id, a, 1, 0, 0, 0, Convert.ToInt32(DA_Spectral.inharmonic_sample_playback_modes.sample_playback_mode_one_shot), Convert.ToInt32(DA_Spectral.inharmonic_samples.inharmonic_sample_none));
                        adsr_sectionRow import_adsrsr = iCGS.Table_adsr_section.GetRow(import_patch_id, a);
                        adsr_sectionRow new_adsrsr = CGS.Table_adsr_section.GetRow(new_patch_id, a);
                        new_adsrsr.end_time_ms = import_adsrsr.end_time_ms;
                        new_adsrsr.end_time_ms_keyscale_upper = import_adsrsr.end_time_ms_keyscale_upper;
                        new_adsrsr.end_time_ms_keyscale_lower = import_adsrsr.end_time_ms_keyscale_lower;
                        new_adsrsr.flag_active = import_adsrsr.flag_active;
                        new_adsrsr.inharmonic_sample_id = import_adsrsr.inharmonic_sample_id;
                        new_adsrsr.inharmonic_sample_playback_mode_id = import_adsrsr.inharmonic_sample_playback_mode_id;

                        for (Int32 v = 0; v < DA_Spectral.max_envelopes; v++)
                        {
                            CGS.Table_adsr_section_envelope_config.AddRow3(new_patch_id, a, v, Convert.ToInt32(DA_Spectral.env_types.env_type_none), 0, 0, 0, 0, 0, 0, 3, 0, 0);
                            adsr_section_envelope_configRow import_adsrsecr = iCGS.Table_adsr_section_envelope_config.GetRow(import_patch_id, a, v);
                            adsr_section_envelope_configRow new_adsrsecr = CGS.Table_adsr_section_envelope_config.GetRow(new_patch_id, a, v);
                            new_adsrsecr.depth_env_exp_multiplier = import_adsrsecr.depth_env_exp_multiplier;
                            new_adsrsecr.depth_env_exp_multiplier_keyscale_upper = import_adsrsecr.depth_env_exp_multiplier_keyscale_upper;
                            new_adsrsecr.depth_env_exp_multiplier_keyscale_lower = import_adsrsecr.depth_env_exp_multiplier_keyscale_lower;
                            new_adsrsecr.depth_env_lin_delta = import_adsrsecr.depth_env_lin_delta;
                            new_adsrsecr.depth_env_lin_delta_keyscale_upper = import_adsrsecr.depth_env_lin_delta_keyscale_upper;
                            new_adsrsecr.depth_env_lin_delta_keyscale_lower = import_adsrsecr.depth_env_lin_delta_keyscale_lower;
                            new_adsrsecr.depth_env_target = import_adsrsecr.depth_env_target;
                            new_adsrsecr.depth_env_target_keyscale_upper = import_adsrsecr.depth_env_target_keyscale_upper;
                            new_adsrsecr.depth_env_target_keyscale_lower = import_adsrsecr.depth_env_target_keyscale_lower;
                            new_adsrsecr.depth_env_type_id = import_adsrsecr.depth_env_type_id;
                        }
                    }

                    for (Int32 f = 0; f < DA_Spectral.max_envelopes; f++)
                    {
                        CGS.Table_envelope_control.AddRow3(new_patch_id, f, iCGS.Table_envelope_control.GetRow(import_patch_id, f).depth_initial_level, iCGS.Table_envelope_control.GetRow(import_patch_id, f).gain_cc_source);
                    }

                    //WaveSet
                    Int32 import_waveform_set_id = iCGS.Table_patch.GetRow(import_patch_id).waveform_set_id;
                    string import_waveform_set_guid8 = iCGS.Table_waveform_set.GetRow(import_waveform_set_id).waveform_set_guid8;
                    if (WaveformSetGUIDExists(import_waveform_set_guid8) == false)
                    {
                        waveform_setRow import_wsr = iCGS.Table_waveform_set.GetRow(import_waveform_set_id);
                        Int32 new_waveform_set_id = CGS.Table_waveform_set.AddRow2(import_waveform_set_guid8, import_wsr.waveform_set_name, import_wsr.timbre_mode, import_wsr.intensity_controller_source, import_wsr.waveform_controller_source);

                        CGS.Table_patch.GetRow(new_patch_id).waveform_set_id = new_waveform_set_id;

                        for (Int32 n = 0; n < DA_Spectral.max_note_sectors; n++)
                        {
                            for (Int32 l = 0; l < DA_Spectral.max_intensity_layers; l++)
                            {
                                for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
                                {
                                    CGS.Table_waveform.AddRow3(new_waveform_set_id, n, l, w, iCGS.Table_waveform.GetRow(import_waveform_set_id, n, l, w).description);

                                    for (Int32 h = 0; h < DA_Spectral.max_harmonics; h++)
                                    {
                                        CGS.Table_waveform_harmonic.AddRow3(new_waveform_set_id, n, l, w, h, iCGS.Table_waveform_harmonic.GetRow(import_waveform_set_id, n, l, w, h).level, 0);
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        Int32 existing_waveset_id = GetExistingWaveformSetIDFromGUID(import_waveform_set_guid8);
                        CGS.Table_patch.GetRow(new_patch_id).waveform_set_id = existing_waveset_id;
                    }


                    //Filter
                    Int32 import_body_resonance_filter_id = iCGS.Table_patch.GetRow(import_patch_id).body_resonance_filter_id;
                    string import_body_resonance_filter_guid8 = iCGS.Table_body_resonance_filter.GetRow(import_body_resonance_filter_id).body_resonance_filter_guid8;
                    if (FilterGUIDExists(import_body_resonance_filter_guid8) == false)
                    {
                        body_resonance_filterRow import_brfr = iCGS.Table_body_resonance_filter.GetRow(import_body_resonance_filter_id);
                        Int32 new_body_resonance_filter_id = CGS.Table_body_resonance_filter.AddRow2(import_brfr.body_resonance_filter_guid8, import_brfr.body_resonance_filter_name);

                        CGS.Table_patch.GetRow(new_patch_id).body_resonance_filter_id = new_body_resonance_filter_id;

                        for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
                        {
                            CGS.Table_body_resonance_filter_band.AddRow3(new_body_resonance_filter_id, b, iCGS.Table_body_resonance_filter_band.GetRow(import_body_resonance_filter_id, b).level, iCGS.Table_body_resonance_filter_band.GetRow(import_body_resonance_filter_id, b).slope);
                        }
                    }
                    else
                    {
                    CGS.Table_patch.GetRow(new_patch_id).body_resonance_filter_id = GetFilterIDFromGUID(import_body_resonance_filter_guid8);
                    }

                    patches_imported++;
                }
                CGS.AcceptChangesOnAllFileData();
            }


            DASystem.flag_initialising_system = false;
            DASystem.flag_saving_or_loading = false;
            DASystem.flag_suppress_patch_events = false;
            DASystem.flag_importing_exporting = false;

            import_summary = "Patches imported = " + patches_imported.ToString() + "\r\n\r\n" + import_summary;

            return error_text;
        }




    }

        #endregion

    }

